from requests import Response


class RequestError(RuntimeError):
    """
    Base Request Error

    Parameters
    ----------
    message : str
        Message that will be customized for the error
    response : Response
        Transmitted response obtained after the request was completed
    """

    def __init__(self, message: str, response: Response):
        super().__init__(message)
        self.message = message
        self.response = response

    @property
    def status_code(self):
        return self.response.status_code

    def __str__(self):
        return f"{self.message} - {self.status_code} - {self.response}"

    def __repr__(self):
        return f"{self.message} - {self.status_code} - {self.response}"


class BadRequestError(RequestError):
    """Bad Request Error"""


class UnauthorizedRequestError(RequestError):
    """Unauthorized Request Error"""


class ForbiddenRequestError(RequestError):
    """Forbidden Request Error"""


class NotFoundRequestError(RequestError):
    """Not Found Request Error"""


class UnprocessableEntityRequestError(RequestError):
    """Unprocessable Entity Request Error"""
