from typing import Any, Optional

from json import JSONDecodeError

import structlog

from apadata.api.api import API
from apadata.constants import SCRAPER_CANONICAL_DOMAIN, SCRAPER_TOKEN

logger = structlog.get_logger(__name__)


class ScraperAPI(API):
    """
    Class that gets requests results from Apadua's scraper
    """

    def __init__(self):
        super().__init__(
            api_url=SCRAPER_CANONICAL_DOMAIN,
            headers={"Authorization": f"token {SCRAPER_TOKEN}"},
        )

    def frequency_features(self, keyword: str, domain: Optional[str] = None) -> Any:
        """
        Receives a keyword and a domain for a company and retrieves some frequency
        features computed for that keyword and domain if one domain is provided
        """
        endpoint = "api/frequencies"
        query_params = {"keyword": keyword}
        if domain:
            query_params["domain"] = domain
        response = self.get(endpoint=endpoint, query_params=query_params)
        try:
            frequency_features = response.json()
        except JSONDecodeError as e:
            logger.error("Error decoding JSON", error=e)
            return None
        return frequency_features
