import logging
from os import environ, path

OPENAI_API_BASE = environ.get(
    "OPENAI_ENDPOINT", "https://apadua-openai-switzerland.openai.azure.com/"
)
CHATGPT_SUBSCRIPTION_ID = environ.get("CHATGPT_SUBSCRIPTION_ID")
OPENAI_API_TYPE = environ.get("OPENAI_API_TYPE", "azure")
OPENAI_API_KEY = environ.get("OPENAI_API_KEY", "7b331078c1a949029cba1efa2329d5bb")
OPEN_AI_VERSION = environ.get("OPENAI_API_VERSION", "2023-09-01-preview")

ENVIRONMENT = environ.get("ENVIRONMENT", "development")
CLEARBIT_API_KEY = environ.get("CLEARBIT_API_KEY")
ELASTICSEARCH_URL = environ.get(
    "ELASTICSEARCH_URL", "http://elastic:Wq41pnunG30M65nv8X62OHI9@20.79.73.167:9200"
)
SCRAPER_CANONICAL_DOMAIN = environ.get(
    "SCRAPER_CANONICAL_DOMAIN", "https://scraper.apadua.com"
)
SCRAPER_TOKEN = environ.get("SCRAPER_TOKEN", "85e1c4fd65dc963f1674942a286357c2506927e9")

logging.info("Starting Apadata in [%s] mode!", ENVIRONMENT)

PROJECT_DIR = path.dirname(path.abspath(__file__))

DATABASE_DIR = path.join(PROJECT_DIR, "../databases")

SENTRY_DSN = environ.get(
    "SENTRY_DSN",
    "https://9aa104f28ca4cdf16090413506b47d6f@o4505629744627712"
    + ".ingest.sentry.io/4505629746987008",
)
DEFAULT_SCORE = 0.5

PINECONE_API_KEY = environ.get(
    "PINECONE_API_KEY", "70c96cec-121a-46ce-9912-83db7b4457b1"
)
PINECONE_ENVIRONMENT = environ.get("PINECONE_ENVIRONMENT", "gcp-starter")
