from typing import Any, List

from abc import ABC, abstractmethod


class Importer(ABC):
    """Abstract class for data importers"""

    data: List[Any]
    imported_rows: List[Any]

    def __init__(self):
        self.data = []
        self.imported_rows = []

    def before_import(self, data):
        return data

    def before_import_row(self, row):
        return row

    @abstractmethod
    def import_row(self, row):
        pass

    def after_import_row(self, row):
        return row

    def after_import(self, data, imported_rows):  # pylint: disable=unused-argument
        return data

    def load(self):
        self.data = []

    def import_data(self):
        self.load()
        self.before_import(self.data)
        self.imported_rows = []
        for row in self.data:
            row = self.before_import_row(row)
            self.imported_rows.append(self.import_row(row))
            self.after_import_row(row)
        self.after_import(self.data, self.imported_rows)

    def save(self):
        pass
