# pylint: disable=duplicate-code
from typing import List

from django_rq import job

from apadata.tasks import classify_keywords_task


@job("default")
def classify_keywords_job(*, keyword: str, categories: List[str]) -> float:
    if not categories:
        categories = ["topic", "tech", "function", "service", "industry"]
    return float(classify_keywords_task(keyword=keyword, categories=categories))
