from django_rq import job
from structlog import get_logger

from apadata.tasks import extract_summary_task

logger = get_logger(__name__)


@job("default")
def extract_summary_job(
    *,
    domain: str,
    company: str,
    keyword: str,
    recalculate: bool = False,
    prompt_index: int = 0,
) -> str:
    return extract_summary_task(
        domain=domain,
        company=company,
        keyword=keyword,
        recalculate=recalculate,
        prompt_index=prompt_index,
    )
