from typing import Any, List, Optional

from os import path

import numpy as np

from apadata.constants import PROJECT_DIR

from .loader import IDENTIFIER, Loader


class NumpyLoader(Loader):
    """
    Text data loader

    Parameters
    ----------
    filepath : str
        Filepath from which a text will be loaded
    """

    def __init__(self, filepath: str):
        self.filepath = filepath

    def load(self) -> Any:
        return np.load(path.join(PROJECT_DIR, self.filepath), allow_pickle=True)

    def list(self) -> Optional[List[Any]]:
        pass

    def get(self, key: IDENTIFIER) -> Optional[Any]:
        pass

    def search(self, query: Any) -> None:
        pass
