from typing import Any, List

from os import path

from openpyxl import load_workbook

from apadata.constants import PROJECT_DIR

from .loader import IDENTIFIER, Loader


class XLSXLoader(Loader):
    """XLSX data loader"""

    def __init__(self, filepath: str, delimiter: str = ","):
        self.filepath = filepath
        self.delimiter = delimiter
        self.data: List[Any] = []

    def load(self) -> List[Any]:
        """Load data"""
        workbook = load_workbook(filename=path.join(PROJECT_DIR, self.filepath))
        worksheet = workbook.worksheets[0]
        self.data = [[cell.value for cell in row] for row in worksheet.rows]
        return self.data

    def list(self):
        pass

    def get(self, key: IDENTIFIER) -> None:
        pass

    def search(self, query: Any) -> None:
        pass
