from django.db import models


class Acronym(models.Model):
    """
    Contains the Acronyms together with their full forms (which are used then for the
    deacronymizer component)

    In order for this model to work properly you would need to have a file called
    "acronym.json" located in at the "apadata/fixtures" path.

    This json should be a list of dictionaries where each dictionary in the list has
    this structure:

    {
        "fields": {
            "acronym": str,
            "full_form": str
        },
        "pk": int,
        "model": "apadata.acronym"
    }

    If you do not have this json, you can download it from the below google drive link:
    https://drive.google.com/file/d/1dwgYmi-TZLchKSwdpNbH9E6DkhPuRXU0/view?usp=sharing

    Sorry for the inconvenience, the reason why this file was not pushed to Github
    is due to the maximum per file size limit of 100 MB. Thus, it should always be
    git ignored.
    """

    full_form = models.CharField(max_length=100, unique=True, null=False, blank=False)
    acronym = models.CharField(max_length=100, unique=True, null=False, blank=False)
