from django.db import models


class Keyword(models.Model):
    """Contains the industry keywords"""

    name = models.CharField(max_length=100, unique=True, null=False, blank=False)
    relevance_score = models.ManyToManyField(
        "Domain", related_name="relevance_scores", through="KeywordDomainRelevance"
    )
    category = models.CharField(max_length=100, default="")
    discarded = models.BooleanField(default=False)
    similars = models.ManyToManyField(
        "self",
        through="SimilarKeywords",
        symmetrical=True,
    )
    discarded_reason = models.CharField(default="", max_length=100)
    lemma_form = models.CharField(default="", max_length=100)
    en_translation = models.CharField(max_length=100, default="")
    language = models.CharField(max_length=100, default="")
    source = models.CharField(default="linkedin", max_length=100)
    created_at = models.DateTimeField(auto_now_add=True)
    embedding = models.JSONField(default=None)
