from django.db import models

from apadata.models import Domain, Keyword


class KeywordDomainRelevance(models.Model):
    """ Class used for the mapping between a keyword and a domain to a relevance
    score"""
    keyword = models.ForeignKey(Keyword, on_delete=models.CASCADE)
    domain = models.ForeignKey(Domain, on_delete=models.CASCADE)
    relevance_score = models.FloatField()

    class Meta:
        unique_together = ["keyword", "domain"]
