from django.db import models

from apadata.models.domain import Domain


class Summary(models.Model):
    """Persists the result computed by the target industry pipeline given a domain"""

    company = models.CharField(max_length=100, null=False, blank=False)
    domain = models.ForeignKey(
        Domain,
        on_delete=models.CASCADE,
    )
    keyword = models.CharField(max_length=100, null=False, blank=False)
    text = models.TextField(null=False, blank=False)

    created_at = models.DateField(auto_now_add=True)
    last_updated_at = models.DateField(auto_now=True)
