from typing import Any, List

import time

from cachetools.func import ttl_cache
from django.db import models

from apadata.utils import flatten


class UrlTag(models.Model):
    """UrlTag class that contains the mapping from each language to the tags in that
    respective language"""

    name = models.CharField(max_length=100, null=False, blank=False)
    translations = models.JSONField()

    @staticmethod
    @ttl_cache(maxsize=10_000, ttl=86_400, timer=time.monotonic, typed=False)
    def load_all() -> List[Any]:
        return list(UrlTag.objects.all())

    @staticmethod
    @ttl_cache(maxsize=10_000, ttl=86_400, timer=time.monotonic, typed=False)
    def get_translations_by_language(language: str) -> List[Any]:
        return [object.translations[language] for object in UrlTag.load_all()]

    @staticmethod
    def get_translations_by_languages(languages: List[str]) -> List[Any]:
        return flatten(
            [UrlTag.get_translations_by_language(language) for language in languages]
        )
