from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.keywords_frequency_evaluator import (
    KeywordsFrequencyEvaluator,
)

Input = Dict[str, Any]
Output = Dict[str, Any]


class KeywordsFrequencyEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "keywords_frequency_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        domain = context.search_field("domain")
        evaluator = KeywordsFrequencyEvaluator(domain)
        score = evaluator.evaluate(keyword)
        context.add("keywords_frequency_score", score)
        return dict(context.payload)
