from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.language_frequency_evaluator import (
    LanguageFrequencyEvaluator,
)

Input = Dict[str, Any]
Output = Dict[str, Any]


class LanguageFrequencyEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "language_frequency_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        language = context.search_field("language")
        evaluator = LanguageFrequencyEvaluator(language=language)
        score = evaluator.evaluate(keyword)
        context.add("language_frequency_score", score)
        return dict(context.payload)
