from typing import Any, Dict

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule
from apadata.text_processors.evaluators.linguistical_evaluator import (
    LinguisticalEvaluator,
)

Input = Dict[str, Any]
Output = Dict[str, Any]


class LinguisticalEvaluatorModule(PipelineModule[Input, Output]):
    """Class for instantiating an object"""

    def __init__(
        self,
        name: str = "linguistical_evaluator",
        **kwargs: Any,
    ):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        keyword = context.search_field("keyword")
        language = context.search_field("language")
        evaluator = LinguisticalEvaluator(language=language)
        score = evaluator.evaluate(keyword)
        context.add("linguistical_score", score)
        return dict(context.payload)
