from typing import Any, Dict

from apadata.api.sitemap_api.sitemap_api import SitemapAPI
from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.pipeline_module import PipelineModule

Input = Dict[str, Any]
Output = Dict[str, Any]


class SitemapAPIModule(PipelineModule[Input, Output]):
    """Class for instantiating SitemapExtractor object"""

    def __init__(self, name: str = "sitemap", **kwargs: Any):
        super().__init__(name, **kwargs)

    def run(self, context: PipelineContext) -> Output:
        domain = context.search_field("domain")
        sitemap_extractor = SitemapAPI(domain=domain, sitemap=None)
        sitemap_extractor.determine_sitemap()
        sitemap_extractor.categorize_sitemap()
        context.add("sitemap", sitemap_extractor.sitemap)
        context.add("domain", domain)
        context.add("categories_to_urls", sitemap_extractor.categories_to_urls)
        return dict(context.payload)
