from unittest.mock import patch

from apadata.modules.evaluators.keywords_frequency_evaluator_module import (
    KeywordsFrequencyEvaluatorModule,
)
from apadata.pipelines.pipeline_context import PipelineContext

PAYLOAD = [
    {
        "keyword": "Consulting",
        "domain": "hmp-consulting.com",
        "number_of_pages": 2441,
        "content_hits": 5,
        "title_hits": 41,
        "url_hits": 2441,
        "content_score": 56,
        "title_score": 426,
        "url_score": 12788,
        "created_at": "2023-10-06T09:47:45.296789Z",
        "updated_at": "2023-10-06T09:47:45.296792Z",
    },
    {
        "keyword": "Consulting",
        "domain": "consultingpoint.com",
        "number_of_pages": 2320,
        "content_hits": 1187,
        "title_hits": 2106,
        "url_hits": 106,
        "content_score": 10346,
        "title_score": 14436,
        "url_score": 1525,
        "created_at": "2023-10-06T09:47:45.296831Z",
        "updated_at": "2023-10-06T09:47:45.296835Z",
    },
]


class TestResponse:
    """Test Response"""

    def __init__(self, payload):
        self.payload = payload
        self.status_code = 200

    def json(self):
        return self.payload


@patch("apadata.api.api.requests.get")
def test_keywords_frequency_evaluator_module(mock_api):
    mock_api.return_value = TestResponse(PAYLOAD)
    payload = {"keyword": "Consulting", "domain": "consultingpoint.com"}
    context = PipelineContext(payload=payload)
    module = KeywordsFrequencyEvaluatorModule()
    module.run(context)
    assert round(context.search_field("keywords_frequency_score"), 4) == 0.7296
