from apadata.modules.evaluators.location_evaluator_module import LocationEvaluatorModule
from apadata.pipelines.pipeline_context import PipelineContext


def test_location_evaluator_module():
    payload = {"keyword": "Consulting"}
    context = PipelineContext(payload=payload)
    module = LocationEvaluatorModule()
    module.run(context)
    assert context.search_field("location_score") == 1.0

    payload = {"keyword": "Consulting of America"}
    context = PipelineContext(payload=payload)
    module = LocationEvaluatorModule()
    module.run(context)
    assert context.search_field("location_score") == 0.0
