from apadata.modules.evaluators.spelling_evaluator_module import SpellingEvaluatorModule
from apadata.pipelines.pipeline_context import PipelineContext


def test_spelling_evaluator_module():
    payload = {
        "keyword": "Consulting",
        "language": "en",
    }
    context = PipelineContext(payload=payload)
    module = SpellingEvaluatorModule()
    module.run(context)
    assert context.search_field("spelling_score") == 1.0

    payload = {
        "keyword": "Consutlingting",
        "language": "en",
    }
    context = PipelineContext(payload=payload)
    module = SpellingEvaluatorModule()
    module.run(context)
    assert context.search_field("spelling_score") == 0.0
