from unittest.mock import patch

from apadata.modules.evaluators.wikipedia_evaluator_module import (
    WikipediaEvaluatorModule,
)
from apadata.pipelines.pipeline_context import PipelineContext


@patch("apadata.text_processors.evaluators.wikipedia_evaluator.wikipedia.search")
def test_wikipedia_evaluator_module(mock_wikipedia):
    mock_wikipedia.return_value = ["Wikipedia Title 1"]
    payload = {"keyword": "Biotechnology"}
    context = PipelineContext(payload=payload)
    module = WikipediaEvaluatorModule()
    module.run(context)
    assert context.search_field("wikipedia_score") == 1.0
