from typing import Any, Dict

from apadata.models import Keyword
from apadata.modules.keywords.case_insensitive_finder_module import (
    CaseInsensitiveFinderModule,
)
from apadata.pipelines.pipeline_context import PipelineContext


def test_case_insensitive_finder_module():
    payload: Dict[str, Any] = {"keyword": "Consulting"}
    context = PipelineContext(payload=payload)
    module = CaseInsensitiveFinderModule()
    module.run(context)
    keyword_objects = Keyword.objects.filter(name__iexact=payload["keyword"])
    discarded_list = [keyword_object.discarded for keyword_object in keyword_objects]
    assert all([isinstance(elem, bool) for elem in discarded_list])
    assert discarded_list.count(False) == 0
