from unittest.mock import patch

from apadata.modules.clearbit_api_module import ClearbitAPIModule
from apadata.pipelines.pipeline_context import PipelineContext


@patch("apadata.api.clearbit.clearbit_api.ClearbitAPI.suggest")
@patch("apadata.api.clearbit.clearbit_api.ClearbitAPI.industry")
def test_clearbit_api_module(mock_industry, mock_suggest):
    mock_suggest.return_value = ["kpmg.us"]
    mock_industry.return_value = "Consulting"
    payload = {"company_names": ["KPMG"]}
    context = PipelineContext(payload=payload)
    clearbit_module: ClearbitAPIModule = ClearbitAPIModule()
    clearbit_module.run(context)
    mock_industry.assert_called_once_with(domain="kpmg.us")
    assert context.get("target_industries") == ["Consulting"]
