from unittest.mock import patch

from apadata.modules.keyword_category_module import KeywordCategoryModule
from apadata.pipelines.pipeline_context import PipelineContext


@patch("apadata.chatgpt.chat_gpt.openai")
def test_keyword_category_module(mock_openai):
    mock_response = {
        "choices": [{"message": {"role": "mock-role", "content": "service"}}]
    }
    mock_openai.ChatCompletion.create.return_value = mock_response
    keyword = "Consulting"
    categories = ["topic", "tech", "function", "service", "industry"]
    payload = {"keyword": keyword, "categories": categories}
    context = PipelineContext(payload=payload)
    context.add("temperature", 2.0)
    context.add("prompt_index", 0)
    gpt_module: KeywordCategoryModule = KeywordCategoryModule()
    module_output = gpt_module.run(context)
    assert module_output == "service"
