import pytest

from ...pipelines.pipeline_context import PipelineContext
from ..lang_detect_text_processor_module import LangDetectTextProcessorModule


def test_lang_detect_text_processor_module():
    payloads = [
        "Hello there! How are you?",
        {"text": "Hello there! How are you?"},
        3.14,
    ]
    for payload in payloads:
        context = PipelineContext(payload=payload)
        lang_det_module: LangDetectTextProcessorModule = LangDetectTextProcessorModule()
        if isinstance(payload, float):
            with pytest.raises(ValueError):
                lang_det_module.run(context)
        else:
            returned_payload = lang_det_module.run(context)
            assert payload == returned_payload
            assert context.get("language") == "en"
