from apadata.modules.text_embedder_processor_module import TextEmbedderProcessorModule
from apadata.pipelines.pipeline_context import PipelineContext


def test_text_embedder_processor_module():
    payload = {"text": "Hello there! How are you?"}
    context = PipelineContext(payload=payload)
    text_embedder_module: TextEmbedderProcessorModule = TextEmbedderProcessorModule()
    returned_payload = text_embedder_module.run(context)
    assert payload == returned_payload
    embedding = context.get("embedding")
    assert isinstance(embedding, list)
    assert all([isinstance(value, float) for value in embedding])
