from apadata.modules.keywords.case_insensitive_finder_module import (
    CaseInsensitiveFinderModule,
)
from apadata.modules.keywords.cross_translator_module import CrossTranslatorModule
from apadata.modules.keywords.deacronymizer_module import DeacronymizerModule
from apadata.modules.keywords.lemma_finder_module import LemmaFinderModule
from apadata.modules.keywords.similarity_finder_module import SimilarityFinderModule
from apadata.modules.keywords.synonymy_finder_module import SynonymyFinderModule
from apadata.pipelines.pipeline import Pipeline
from apadata.pipelines.pipeline_context import PipelineContext
from apadata.spacy.constants import KeywordsProcessingMode


class KeywordsEnrichmentPipeline(Pipeline):
    """
    A pipeline for summarizing company content.
    This pipeline is designed to automatically generate concise summaries of
    company web content centered around important domain keywords using ChatGpt.

    @param context:Dict[str, Any] - contains input payload with a companies name,
    domain and keyword
    @return: str - summary
    """

    def __init__(
        self,
        context: PipelineContext,
    ):
        super().__init__(
            context,
            [
                CaseInsensitiveFinderModule(mode=KeywordsProcessingMode.ENRICH),
                CrossTranslatorModule(mode=KeywordsProcessingMode.ENRICH),
                DeacronymizerModule(mode=KeywordsProcessingMode.ENRICH),
                SimilarityFinderModule(mode=KeywordsProcessingMode.ENRICH),
                SynonymyFinderModule(mode=KeywordsProcessingMode.ENRICH),
                LemmaFinderModule(mode=KeywordsProcessingMode.ENRICH),
            ],
        )
