from typing import Any, Dict, List

from apadata.modules.keywords.case_insensitive_finder_module import (
    CaseInsensitiveFinderModule,
)
from apadata.modules.keywords.cross_translator_module import CrossTranslatorModule
from apadata.modules.keywords.deacronymizer_module import DeacronymizerModule
from apadata.modules.keywords.lemma_finder_module import LemmaFinderModule
from apadata.modules.keywords.similarity_finder_module import SimilarityFinderModule
from apadata.modules.keywords.synonymy_finder_module import SynonymyFinderModule
from apadata.pipelines.pipeline import Pipeline
from apadata.pipelines.pipeline_context import PipelineContext
from apadata.text_processors import SpacyTextProcessor

out_of_interval_values: List[str] = []
uncalculated_criteria: List[str] = []

spell_checker_dict: Dict[str, Any] = {}
spacy_pipelines_dictionary: Dict[str, SpacyTextProcessor] = {}


class KeywordsRemoverPipeline(Pipeline):
    """
    Class that performs the whole target industries extraction pipeline

    Parameters
    ----------
    context: PipelineContext
        Context of the pipeline which receives and passes along data across a
        pipeline enriching it with information from several modules
    """

    def __init__(
        self,
        context: PipelineContext,
    ):
        super().__init__(
            context=context,
            modules=[
                CaseInsensitiveFinderModule(),
                LemmaFinderModule(),
                SynonymyFinderModule(),
                CrossTranslatorModule(),
                DeacronymizerModule(),
                SimilarityFinderModule(),
            ],
        )
