from unittest.mock import patch

from apadata.pipelines.classify_keywords_pipeline import ClassifyKeywordsPipeline
from apadata.pipelines.pipeline_context import PipelineContext


@patch("apadata.chatgpt.chat_gpt.openai")
def test_classify_keywords_pipeline(mock_openai):
    mock_response = {
        "choices": [{"message": {"role": "mock-role", "content": "service"}}]
    }
    mock_openai.ChatCompletion.create.return_value = mock_response
    payload = {
        "keyword": "cool",
        "categories": ["topic", "tech", "function", "service", "industry"],
    }

    context = PipelineContext(payload=payload)
    summaries_pipeline = ClassifyKeywordsPipeline(context=context)
    pipeline_output = summaries_pipeline.run()
    assert pipeline_output.result == "service"
