from unittest.mock import patch

from ..evaluator_pipeline import EvaluatorPipeline
from ..pipeline_context import PipelineContext

PAYLOAD = [
    {
        "keyword": "Consulting",
        "domain": "hmp-consulting.com",
        "number_of_pages": 2441,
        "content_hits": 5,
        "title_hits": 41,
        "url_hits": 2441,
        "content_score": 56,
        "title_score": 426,
        "url_score": 12788,
        "created_at": "2023-10-06T09:47:45.296789Z",
        "updated_at": "2023-10-06T09:47:45.296792Z",
    },
    {
        "keyword": "Consulting",
        "domain": "consultingpoint.com",
        "number_of_pages": 2320,
        "content_hits": 1187,
        "title_hits": 2106,
        "url_hits": 106,
        "content_score": 10346,
        "title_score": 14436,
        "url_score": 1525,
        "created_at": "2023-10-06T09:47:45.296831Z",
        "updated_at": "2023-10-06T09:47:45.296835Z",
    },
]


class TestResponse:
    """Test Response"""

    def __init__(self, payload):
        self.payload = payload
        self.status_code = 200

    def json(self):
        return self.payload


@patch("apadata.api.api.requests.get")
@patch("apadata.text_processors.evaluators.wikipedia_evaluator.wikipedia.search")
def test_evaluator_pipeline(mock_wikipedia, mock_api):
    mock_wikipedia.return_value = ["Wikipedia Title 1"]
    mock_api.return_value = TestResponse(PAYLOAD)
    payload = {
        "keyword": "Consulting",
        "language": "en",
        "domain": "consultingpoint.com",
        "strategy": "weighted_mean"
    }
    context = PipelineContext(payload=payload)

    # Full pipeline
    evaluator_pipeline = EvaluatorPipeline(context=context)
    context_result = evaluator_pipeline.run()
    assert isinstance(context_result.result, dict)
    assert len(context_result.result) == 1
    assert "relevance_score" in context_result.result
    assert isinstance(context_result.result["relevance_score"], float)
    assert context_result.result["relevance_score"] == 0.9211
