from apadata.models import Keyword
from apadata.pipelines.keywords_enrichment_pipeline import KeywordsEnrichmentPipeline
from apadata.pipelines.pipeline_context import PipelineContext


def test_keywords_enrichment_pipeline():
    payload = {
        "keyword": "consulting",
    }
    context = PipelineContext(payload=payload)
    keywords_enrichment_pipeline = KeywordsEnrichmentPipeline(context=context)
    context = keywords_enrichment_pipeline.run()
    expected_result = sorted(
        [
            "confer",
            "consulting",
            "consultings",
            "refer",
            "look_up",
            "confabulate",
            "confer_with",
            "confab",
            "CONSULTING",
        ]
    )
    for keyword in expected_result:
        assert Keyword.objects.get(name=keyword)
