from django.db import models

from apadata.models import Keyword
from apadata.pipelines.keywords_remover_pipeline import KeywordsRemoverPipeline
from apadata.pipelines.pipeline_context import PipelineContext


def test_keywords_remover_pipeline():
    keywords = [
        "BEL",
        "Consulting",
        "consulting",
        "Verwaltung",
        "load",
        "consultancy",
        "consult",
    ]
    discarded_mapping = {
        "BEL": True,
        "Bharat Electronics Limited": False,
        "Consulting": True,
        "consulting": True,
        "Administration": False,
        "Verwaltung": True,
        "loads": True,
        "load": True,
        "consultancy": True,
        "consult": True,
    }

    for keyword in keywords:
        payload = {"keyword": keyword}
        context = PipelineContext(payload=payload)

        # Full pipeline
        evaluator_pipeline = KeywordsRemoverPipeline(context=context)
        evaluator_pipeline.run()

    for (keyword, discarded) in discarded_mapping.items():
        try:
            keyword_obj = Keyword.objects.get(name=keyword)
        except models.ObjectDoesNotExist:
            continue
        assert keyword_obj.discarded == discarded, keyword_obj.name
