import pytest

from apadata.pipelines.pipeline import Pipeline
from apadata.pipelines.pipeline_context import PipelineContext


def test_pipeline_context():
    context: PipelineContext = PipelineContext({"a": 1})

    context.add("module1", "mod1")

    with pytest.raises(SyntaxError):
        context.add("module1", "mod1")

    context.update("module1", "mod2")

    assert context.get("module1") == "mod2"

    with pytest.raises(SyntaxError):
        context.update("module2", "mod2")

    assert context.get("module2") is None

    context.merge("module1", "mod2")

    assert context.get("module1") == "mod2mod2"

    context.add("module3", {1})
    context.merge("module3", {2})
    assert context.get("module3") == {1, 2}

    context.add("module4", {"a": 1})
    context.merge("module4", {"b": 2})

    assert context.search_field("module1") == "mod2mod2"

    assert context.get("module4") == {"a": 1, "b": 2}

    context.add("module5", "ABC")
    context.merge("module5", "DEF")
    assert context.get("module5", "ABCDEF")

    pipeline = Pipeline(context)
    context_result = pipeline.run()

    assert context_result.payload == {"a": 1}
    assert context_result.search_field("a") == 1

    assert context_result.result is None
