from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.text_embedder_processor_pipeline import (
    TextEmbedderProcessorPipeline,
)


def test_text_embedder_processor_pipeline():
    payload = {"text": "consulting"}
    context = PipelineContext(payload=payload)

    # Full pipeline
    target_full_pipeline = TextEmbedderProcessorPipeline(context=context)
    context_result = target_full_pipeline.run()

    embedding = context_result.result["embedding"]

    assert isinstance(embedding, list)
    assert all([isinstance(value, float) for value in embedding])
