from typing import Any, List

from statistics import mean

from .score_strategy import ScoreStrategy


class MeanScoreStrategy(ScoreStrategy):
    """ScoreStrategy class for the cases where we want to do compute the mean of
    our scores"""

    @classmethod
    def calculate(cls, array: List[Any]) -> float:
        return float(mean(array))
