from typing import Any, List

from abc import ABC, abstractmethod

from apadata.utils.enum import StrEnum


class ScoreStrategyEnum(StrEnum):
    """
    Class that tells us whether the evaluation strategy for an evaluator should be
    to do to the mean or pick the highest value
    """

    HIGHEST = "highest"
    MEAN = "mean"
    WEIGHTED_MEAN = "weighted_mean"


class ScoreStrategy(ABC):
    """Abstract class the defines the behavior of any ScoreStrategy class"""

    @classmethod
    @abstractmethod
    def calculate(cls, array: List[Any]) -> float:
        pass
