from typing import Callable

from .highest_score_strategy import HighestScoreStrategy
from .mean_score_strategy import MeanScoreStrategy
from .score_strategy import ScoreStrategy, ScoreStrategyEnum
from .weighted_mean_score_strategy import WeightedMeanScoreStrategy


class ScoreStrategyFactory:
    """Factory class for our ScoreStrategy class"""

    STRATEGIES = {
        ScoreStrategyEnum.MEAN: MeanScoreStrategy,
        ScoreStrategyEnum.HIGHEST: HighestScoreStrategy,
        ScoreStrategyEnum.WEIGHTED_MEAN: WeightedMeanScoreStrategy,
    }

    @staticmethod
    def create(strategy: ScoreStrategyEnum) -> ScoreStrategy:
        strategy_class: Callable[[], ScoreStrategy] = ScoreStrategyFactory.STRATEGIES[
            strategy
        ]
        return strategy_class()
