from typing import Any, List

from .score_strategy import ScoreStrategy


class WeightedMeanScoreStrategy(ScoreStrategy):
    """ScoreStrategy class for the cases where we want to do compute the mean of
    our scores"""

    @classmethod
    def calculate(cls, array: List[Any]) -> float:
        values, weights = zip(*array)
        weights_sum = sum(weights)
        result = sum(value * weight for value, weight in zip(values, weights))
        if weights_sum:
            return float(result / weights_sum)
        return 0.0
