from unittest.mock import patch

from apadata.tasks.evaluator_task import evaluator_task

PAYLOAD = [
    {
        "keyword": "Consulting",
        "domain": "hmp-consulting.com",
        "number_of_pages": 2441,
        "content_hits": 5,
        "title_hits": 41,
        "url_hits": 2441,
        "content_score": 56,
        "title_score": 426,
        "url_score": 12788,
        "created_at": "2023-10-06T09:47:45.296789Z",
        "updated_at": "2023-10-06T09:47:45.296792Z",
    },
    {
        "keyword": "Consulting",
        "domain": "consultingpoint.com",
        "number_of_pages": 2320,
        "content_hits": 1187,
        "title_hits": 2106,
        "url_hits": 106,
        "content_score": 10346,
        "title_score": 14436,
        "url_score": 1525,
        "created_at": "2023-10-06T09:47:45.296831Z",
        "updated_at": "2023-10-06T09:47:45.296835Z",
    },
]


class TestResponse:
    """Test Response"""

    def __init__(self, payload):
        self.payload = payload
        self.status_code = 200

    def json(self):
        return self.payload


@patch("apadata.api.api.requests.get")
@patch("apadata.text_processors.evaluators.wikipedia_evaluator.wikipedia.search")
def test_evaluator_task(mock_wikipedia, mock_api):
    mock_wikipedia.return_value = ["Wikipedia Title 1"]
    mock_api.return_value = TestResponse(PAYLOAD)
    keyword = "Consulting"
    domain = "consultingpoint.com"
    relevance_score = evaluator_task(keyword=keyword, domain=domain)
    assert isinstance(relevance_score, float)
    assert relevance_score == 0.9211
