# DJANGO_SETTINGS_MODULE=apadata.settings (either we do this)
#  either manage.py (which automatically loads the settings file)
from typing import Dict, List

from dataclasses import dataclass
from unittest.mock import patch

from apadata.pipelines.pipeline_context import PipelineContext
from apadata.tasks import target_industries_mentions_task


@dataclass
class TestResult:
    result: Dict[str, List[str]]


@patch("apadata.tasks.target_industries_task.TargetIndustriesExtractionPipeline")
def test_target_industries_mentions_task(mock_industries_pipeline):
    mock_industries_pipeline.return_value.run.return_value = TestResult(
        result={"target_industries": ["mining", "fishing"]}
    )
    test_domain = "kearney.com"
    result = target_industries_mentions_task(domain=test_domain)
    assert sorted(result) == sorted(["mining", "fishing"])

    assert "context" in mock_industries_pipeline.mock_calls[0].kwargs
    assert isinstance(
        mock_industries_pipeline.mock_calls[0].kwargs["context"], PipelineContext
    )
    assert mock_industries_pipeline.mock_calls[0].kwargs["context"].payload == {
        "domain": test_domain,
        "size": 512,
    }
