from typing import List

from django.db import models

from apadata.models import Keyword
from apadata.pipelines.pipeline_context import PipelineContext
from apadata.pipelines.text_embedder_processor_pipeline import (
    TextEmbedderProcessorPipeline,
)
from apadata.utils import flatten


def text_embedder_processor_task(*, text: str) -> List[float]:
    payload = {
        "text": text,
    }
    context = PipelineContext(payload=payload)
    embedder_pipeline = TextEmbedderProcessorPipeline(context=context)
    result = embedder_pipeline.run()
    embedding = result.get("embedding")
    try:
        keyword_obj = Keyword.objects.get(name=text)
    except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
        keyword_obj = Keyword.objects.create(name=text)
    keyword_obj.embedding = list(flatten(embedding))
    keyword_obj.save()
    return list(embedding)
