from apadata.text_processors.evaluators.evaluator import Evaluator


class LengthEvaluator(Evaluator):
    """Evaluates the length of a keyword"""

    def __init__(self, min_length: int, max_length: int):
        self.min_length = min_length
        self.max_length = max_length

    def evaluate(self, keyword: str) -> float:
        if self.min_length <= len(keyword) <= self.max_length:
            return 1.0
        return 0.0
