import collections

import geostring as geo

from apadata.text_processors.evaluators.evaluator import Evaluator


class LocationEvaluator(Evaluator):
    """Evaluates a keyword based on whether it mentions a location or not"""

    def evaluate(self, keyword: str) -> float:
        words = keyword.split()
        for word in words:
            result = geo.resolve(word)
            if (
                isinstance(result, collections.OrderedDict)
                and "resolved_country" in result
                and result["resolved_country"]
            ):
                return 0.0
        return 1.0
