# pylint: disable-all
from typing import Optional

from spellchecker import SpellChecker

from apadata.text_processors import LangDetectTextProcessor
from apadata.text_processors.evaluators.evaluator import Evaluator


class SpellingEvaluator(Evaluator):
    def __init__(self, language: Optional[str] = None):
        self.language = language

    def evaluate(self, keyword: str) -> float:
        if not self.language:
            self.language = str(LangDetectTextProcessor(keyword).detect())
        if not self.language:
            return 1.0
        try:
            spell_checker = SpellChecker(language=self.language)
        except ValueError:
            return 1.0
        if spell_checker.correction(keyword) != keyword:
            return 0.0
        return 1.0
