from typing import List

from itertools import permutations

import wikipedia  # noqa pylint: disable=import-error
from nltk.tokenize import word_tokenize

from apadata.text_processors.evaluators.evaluator import Evaluator


class WikipediaEvaluator(Evaluator):
    """
    Uses Wikipedia to evaluate how good is a keyword
    """

    def __init__(
        self, search_all_queries_permutations: bool = False, suggestion: bool = False
    ):
        self.search_all_queries_permutations = search_all_queries_permutations
        self.suggestion = suggestion

    def evaluate(self, keyword: str) -> float:
        keyword_tokens = word_tokenize(keyword)

        keyword_permutations = (
            [
                " ".join(keywords_permutation)
                for keywords_permutation in permutations(keyword_tokens)
            ]
            if self.search_all_queries_permutations
            else []
        )
        search_queries = [keyword] + keyword_permutations

        for search_query in search_queries:
            try:
                result: List[str] = wikipedia.search(
                    search_query, suggestion=self.suggestion
                )
                if result:
                    return 1.0
            except wikipedia.exceptions.PageError:
                continue
        return 0.0
