from typing import Dict, List, Tuple

from apadata.models import Keyword
from apadata.text_processors import TextProcessor


class CaseInsensitiveFinder(TextProcessor):
    """
    This class will find keywords which are identical after lower casing
    """

    def __init__(self, text: str):
        super().__init__(text)

    def process(
        self,
    ) -> Tuple[Dict[str, str], List[Keyword]]:
        keyword_objects = Keyword.objects.filter(name__iexact=self.text)
        cases_format = {
            "title": self.text.title(),
            "upper": self.text.upper(),
            "lower": self.text.lower(),
        }
        return cases_format, keyword_objects
