from apadata.models import Keyword
from apadata.text_processors import LangDetectTextProcessor, TextProcessor
from apadata.text_processors.text_translator import TextTranslator


class CrossTranslator(TextProcessor):
    """
    This class will translate the given keyword from the language in which it is
    written into english, if it exists already in english the english variant will be
    kept and the one in another language other than english will be discarded
    """

    languages = ["en", "de"]

    def __init__(self, text: str):
        super().__init__(text)
        self.keyword_obj = Keyword.objects.get(name=self.text)

    def process(self):
        if not self.keyword_obj.language:
            self.keyword_obj.language = str(LangDetectTextProcessor(self.text).detect())
        if not self.keyword_obj.en_translation:
            if self.keyword_obj.language != "en":
                self.keyword_obj.en_translation = TextTranslator(
                    self.text,
                    source_language=self.keyword_obj.language,
                    destination_language="en",
                ).translate_text()[0]
            else:
                self.keyword_obj.en_translation = self.text

        self.keyword_obj.save()
