from typing import Any

from apadata.models import Keyword
from apadata.text_processors.keywords.case_insensitive_finder import (
    CaseInsensitiveFinder,
)
from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor
from apadata.utils import flatten


class CaseInsensitiveFinderEnricher(CaseInsensitiveFinder):
    """
    This class will find keywords which are identical after lower casing
    """

    def __init__(self, text: str):
        super().__init__(text)

    def process(
        self,
    ) -> Any:
        cases_format, _ = tuple(super().process())
        new_keywords = []
        # it's not a nice fix, but that's how I got around mypy
        if isinstance(cases_format, dict):
            title: str = cases_format["title"]
            upper: str = cases_format["upper"]
            lower: str = cases_format["lower"]
            if len(title):
                if not Keyword.objects.filter(name=title).exists():
                    new_keywords.append(
                        Keyword.objects.create(
                            name=title,
                            embedding=list(
                                flatten(TextEmbedderProcessor(title).process())
                            ),
                        ).name
                    )
            if len(upper):
                if not Keyword.objects.filter(name=upper).exists():
                    new_keywords.append(
                        Keyword.objects.create(
                            name=upper,
                            embedding=list(
                                flatten(TextEmbedderProcessor(upper).process())
                            ),
                        ).name
                    )
            if len(lower):
                if not Keyword.objects.filter(name=lower).exists():
                    new_keywords.append(
                        Keyword.objects.create(
                            name=lower,
                            embedding=list(
                                flatten(TextEmbedderProcessor(lower).process())
                            ),
                        ).name
                    )
        return sorted(new_keywords)
