from typing import List

from apadata.models import Keyword
from apadata.text_processors.keywords.cross_translator import CrossTranslator
from apadata.text_processors.text_translator import TextTranslator


class CrossTranslatorEnricher(CrossTranslator):
    """
    This class will translate the given keyword from the language in which it is
    written into english, if it exists already in english the english variant will be
    kept and the one in another language other than english will be discarded
    """

    languages = ["en", "de"]

    def __init__(self, text: str):
        super().__init__(text)
        self.keyword_obj = Keyword.objects.get(name=self.text)

    def process(self) -> List[str]:
        super().process()
        new_keywords = []
        for language in CrossTranslator.languages:
            if language == self.keyword_obj.language:
                continue
            translated_keyword = TextTranslator(
                self.text,
                source_language=self.keyword_obj.language,
                destination_language=language,
            ).translate_text()[0]
            if not Keyword.objects.filter(name=translated_keyword).exists():
                Keyword.objects.create(
                    name=translated_keyword,
                    embedding=TextTranslator(translated_keyword).process(),
                )
                new_keywords.append(translated_keyword)
        return sorted(new_keywords)
