from typing import List

from django.db import models

from apadata.models import Acronym, Keyword
from apadata.text_processors.keywords.deacronymizer import Deacronymizer
from apadata.text_processors.text_embedder_processor import TextEmbedderProcessor


class DeacronymizerEnricher(Deacronymizer):
    def __init__(self, text: str):
        super().__init__(text)

    def process(self) -> List[str]:
        super().process()
        result = [self.text]
        if Acronym.objects.filter(acronym=self.text).exists():
            deacronymized = str(Acronym.objects.get(acronym=self.text).full_form)
            result = [deacronymized]
            try:
                Keyword.objects.get(name__iexact=deacronymized)
            except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
                Keyword.objects.create(
                    name=deacronymized,
                    embedding=TextEmbedderProcessor(deacronymized).process(),
                )
        if Acronym.objects.filter(full_form=self.text).exists():
            acronym = str(Acronym.objects.get(full_form=self.text).acronym)
            result.append(acronym)
            try:
                Keyword.objects.get(name__iexact=acronym)
            except (models.ObjectDoesNotExist, Keyword.DoesNotExist):
                Keyword.objects.create(
                    name=acronym, embedding=TextEmbedderProcessor(acronym).process()
                )
        return result
